import allure
from selenium.common import TimeoutException

from pages.form_page import FormPage
from tests.base_test import BaseTest


@allure.epic("Форма")
class TestFormPage(BaseTest):
    def setup_method(self):
        self.form_page = FormPage(self.driver)
        self.form_page.open()

    @allure.feature("Заполнение формы")
    @allure.title("Тест заполнения формы с Automation Tools в поле Message")
    def test_fill_form_with_automation_tools(self):
        try:
            with allure.step("Заполнить поле Name"):
                self.form_page.enter_name("Test User")

            with allure.step("Заполнить поле Password"):
                self.form_page.enter_password("testpassword123")

            with allure.step("Выбрать напиток - Coffee"):
                self.form_page.select_drink("Coffee")

            with allure.step("Выбрать цвет - Blue"):
                self.form_page.select_color("Blue")

            with allure.step("Выбрать отношение к автоматизации - Yes"):
                self.form_page.select_automation_opinion("yes")

            with allure.step("Заполнить поле Email"):
                self.form_page.enter_email("test@example.com")

            with allure.step("Получить список Automation tools и заполнить поле Message"):
                tools_text = self.form_page.fill_message_with_automation_tools()

            with allure.step("Проверить, что список Automation Tools получен корректно"):
                expected_tools = ["Selenium", "Playwright", "Cypress", "Appium", "Katalon Studio"]
                for tool in expected_tools:
                    assert tool in tools_text, f"Инструмент {tool} не найден в списке"

            with allure.step("Нажать кнопку Submit"):
                self.form_page.click_submit()

            with allure.step("Проверить, что появилось alert-сообщение"):
                alert_text = self.form_page.get_alert_text()
                assert alert_text == "Message received!", f"Ожидался текст 'Message received!', получен '{alert_text}'"

        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.feature("Automation Tools")
    @allure.title("Тест получения списка Automation Tools")
    def test_get_automation_tools_list(self):
        try:
            with allure.step("Получить список Automation Tools"):
                tools_list = self.form_page.get_automation_tools_list()

            with allure.step("Проверить корректность списка Tools"):
                expected_tools = ["Selenium", "Playwright", "Cypress", "Appium", "Katalon Studio"]
                assert tools_list == expected_tools, f"Ожидался список {expected_tools}, получен {tools_list}"
        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.feature("Валидация формы")
    @allure.title("Тест обязательного поля Name")
    def test_required_name_field(self):
        try:
            with allure.step("Попытаться отправить форму без заполнения обязательного поля"):
                self.form_page.click_submit()
            with allure.step("Проверить, что форма не отправлена (alert не появился)"):
                try:
                    alert_text = self.form_page.get_alert_text()
                    assert False, f"Alert появился, но не должен был. Текст: {alert_text}"
                except TimeoutException:
                    assert True, "Alert не появился - форма не отправлена (ожидаемо)"
        except Exception as e:
            self.allure_screenshot()
            raise e